///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSQLDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND SQLServer_hWnd   = NULL;
    static HWND SQLDriver_hWnd   = NULL;
    static HWND SQLDatabase_hWnd = NULL;
    static HWND SQLUsername_hWnd = NULL;
    static HWND SQLPassword_hWnd = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        SQLServer_hWnd   = GetDlgItem(xHandle, IDC_SERVER);
        SQLDriver_hWnd   = GetDlgItem(xHandle, IDC_SQLDRIVER);
        SQLDatabase_hWnd = GetDlgItem(xHandle, IDC_SQLDATABASE);

        SQLUsername_hWnd = GetDlgItem(xHandle, IDC_SQLUSERNAME);
        SQLPassword_hWnd = GetDlgItem(xHandle, IDC_SQLPASSWORD);


        Set_Text(SQLServer_hWnd, gsSQLServer);
        Set_Text(SQLDriver_hWnd, gsSQLDriver);
        Set_Text(SQLDatabase_hWnd, gsSQLDatabase);

        Set_Text(SQLUsername_hWnd, gsSQLUserID);
        Set_Text(SQLPassword_hWnd, gsSQLPassword);

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            char lsSQLServer[255 + 1];
            int liSQLServerLen = Get_TextEx(SQLServer_hWnd, lsSQLServer, 255);
            if(liSQLServerLen == 0 || liSQLServerLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid SQL server name. Between 1 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLDriver[255 + 1];
            int liSQLDriverLen = Get_TextEx(SQLDriver_hWnd, lsSQLDriver, 255);
            if(liSQLDriverLen == 0 || liSQLDriverLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid SQL driver name. Between 1 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLDatabase[255 + 1];
            int liSQLDatabaseLen = Get_TextEx(SQLDatabase_hWnd, lsSQLDatabase, 255);
            if(liSQLDatabaseLen == 0 || liSQLDatabaseLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid SQL database name. Between 1 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLUsername[255 + 1];
            int liSQLUsernameLen = Get_TextEx(SQLUsername_hWnd, lsSQLUsername, 255);
            if(liSQLUsernameLen == 0 || liSQLUsernameLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid SQL username. Between 1 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsSQLPassword[255 + 1];
            int liSQLPasswordLen = Get_TextEx(SQLPassword_hWnd, lsSQLPassword, 255);
            if(liSQLPasswordLen < 0 || liSQLPasswordLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid SQL password. Between 0 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy(gsSQLServer, lsSQLServer);
            strcpy(gsSQLUserID, lsSQLUsername);
            strcpy(gsSQLPassword, lsSQLPassword);
            strcpy(gsSQLDatabase, lsSQLDatabase);
            strcpy(gsSQLDriver, lsSQLDriver);

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

